!!****h* BigDFT/lazy_60
!! NAME
!!   lazy_60
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 60)
!!
!! SOURCE
!!
integer, parameter :: m=62
real(kind=8), dimension(-m:m) :: ch = (/ &
     0.d0, 0.d0, 0.d0, &
     -1.80960777804178984d-19,0.d0,1.10513064480060885d-17,0.d0,&
       -3.32141991973710259d-16,0.d0,6.54883738891560793d-15,0.d0,&
       -9.5279163579909433d-14,0.d0,1.09084919935365698d-12,0.d0,&
       -1.02354148279779304d-11,0.d0,8.09410105920413478d-11,0.d0,&
       -5.50587106934234749d-10,0.d0,3.27218841600752522d-9,0.d0,&
       -1.71999647508087864d-8,0.d0,8.07595396530604197d-8,0.d0,&
       -3.41497481961512632d-7,0.d0,1.30947169656570694d-6,0.d0,&
       -4.58013372208926991d-6,0.d0,0.0000146880150398035208d0,0.d0,&
       -0.0000433840444231233622d0,0.d0,0.000118515001353520526d0,0.d0,&
       -0.000300581525171972349d0,0.d0,0.000710396937937769235d0,0.d0,&
       -0.00157035112596770041d0,0.d0,0.00325946830347917649d0,0.d0,&
       -0.00638065613347741822d0,0.d0,0.0118436928230099234d0,0.d0,&
       -0.0209956372771539552d0,0.d0,0.0359258682297967678d0,0.d0,&
       -0.0604028333973506096d0,0.d0,0.103355959368799932d0,0.d0,&
       -0.196868494035809394d0,0.d0,0.631336894666561161d0,1.d0,0.631336894666561161d0,&
       0.d0,-0.196868494035809394d0,0.d0,0.103355959368799932d0,0.d0,&
       -0.0604028333973506096d0,0.d0,0.0359258682297967678d0,0.d0,&
       -0.0209956372771539552d0,0.d0,0.0118436928230099234d0,0.d0,&
       -0.00638065613347741822d0,0.d0,0.00325946830347917649d0,0.d0,&
       -0.00157035112596770041d0,0.d0,0.000710396937937769235d0,0.d0,&
       -0.000300581525171972349d0,0.d0,0.000118515001353520526d0,0.d0,&
       -0.0000433840444231233622d0,0.d0,0.0000146880150398035208d0,0.d0,&
       -4.58013372208926991d-6,0.d0,1.30947169656570694d-6,0.d0,&
       -3.41497481961512632d-7,0.d0,8.07595396530604197d-8,0.d0,&
       -1.71999647508087864d-8,0.d0,3.27218841600752522d-9,0.d0,&
       -5.50587106934234749d-10,0.d0,8.09410105920413478d-11,0.d0,&
       -1.02354148279779304d-11,0.d0,1.09084919935365698d-12,0.d0,&
       -9.5279163579909433d-14,0.d0,6.54883738891560793d-15,0.d0,&
       -3.32141991973710259d-16,0.d0,1.10513064480060885d-17,0.d0,&
       -1.80960777804178984d-19,&
     0.d0, 0.d0, 0.d0   /)
real(kind=8), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0.d0
   cg(i)=0.d0
   cgt(i)=0.d0
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1.d0

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1.d0)**(i+1)
   cgt(i+1)=ch(-i)*(-1.d0)**(i+1)
enddo
!!***

